#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

class View:

    def __init__(self):
        self.cms = 'tumblr'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        file = codecs.open(PANEO_SITE_DATA_DIR+"_tumblr.html","r","utf8")
        html_file=file.read()
        file.close()

        tlookup = TemplateLookup(   directories=[PANEO_SITE_DATA_DIR],
                                    input_encoding='utf-8',
                                    output_encoding='utf-8',
                                    default_filters=["none_to_blank", "unicode"],
                                    encoding_errors='replace', 
                                    imports=[   'from utils import none_to_blank,AWS_SEARCH_INDEX,AWS_SORT',
                                                'import web',
                                                'from config import PANEO_SITE_DIR,IMG_CONV,ARTICLES_TYPE,ARTICLES',
                                                'from models import VIEWED',])

        template = Template(    
                                html_file,
                                lookup=tlookup,
        )

        html_file = template.render(
                                web = web,
                                id = 'tumblr',
                                scfg = scfg, 
                                pages = pages,
                                ua_option = "",
        )



        return render.tumblr(     
                                  cms = self.cms,                        
                                  scfg = scfg, 
                                  html_file = html_file,
        )

    def POST( self ):
        i = web.input( PAGEMAKE = 'CMS' )

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        scfg = dic.get('siteconfig')
        dic.close()

        return self.GET()

